#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <qpainter.h>
#include <qdialog.h>
#include <qlineedit.h>

#include <kpopupmenu.h>

#include "webapplet.h"
#include "configurationdialog.h"
#include "addserverdialog.h"

#include <kiconloader.h>
#include <kparts/part.h>
#include <kparts/componentfactory.h>
#include <khtml_part.h>
#include <khtmlview.h>

#include <kaboutdata.h>
#include <kaboutdialog.h>
#include <kaboutapplication.h>
#include <kurl.h>
#include <kmimetype.h>
#include <kprocess.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qscrollview.h>

WebApplet::WebApplet(const QString& configFile, Type type, int actions, QWidget *parent, const char *name) 
  : KPanelApplet(configFile, type, actions, parent, name), popup(0), part(0),
    candidate_url(""), selected_url("")
{
  // Get the current application configuration handle
  //  QString rcfile = dirs()->findResource("config","webappletrc");
  appletConfig = new KConfig("webappletrc", false, true, "config"); 

  ksConfig = config();

  QString urlstr = ksConfig->readEntry("URL","http://www.xspect.dk/kdetestapplet1.php");
  KURL url(urlstr);
  QString mimetype = KMimeType::findByURL( url )->name();
  part = KParts::ComponentFactory::createPartInstanceFromQuery<KParts::ReadOnlyPart>( "text/html", QString::null, this, 0, this, 0 );
  if ( part ) {
    KHTMLPart * _part = static_cast<KHTMLPart*>(part);

    connect(_part,SIGNAL(onURL(const QString&)), 
	    this, SLOT(setBrowserURL(const QString&)));

    part->openURL( url );
    
    
    KHTMLView * qsw = static_cast<KHTMLView*>(_part->widget());
    
    if (qsw ) {
      qsw->setVScrollBarMode(QScrollView::AlwaysOff);
      qsw->setHScrollBarMode(QScrollView::AlwaysOff);
    }else{
      KMessageBox::information(0, i18n("Couldn't get KHTMLPart"));
    }

    part->widget()->setFixedSize(width(), height());
    part->widget()->installEventFilter(this);
    part->widget()->show();  
  }
}   

WebApplet::~WebApplet()
{   
  delete appletConfig;
}

bool WebApplet::eventFilter( QObject *o, QEvent *e )
{
  if ( e->type() == QEvent::MouseButtonPress ) {
    // special processing for key press
    QMouseEvent * mev = static_cast<QMouseEvent*>(e);
    if (mev->button() == QMouseEvent::RightButton) {
      if (!popup) {
	popup = new KPopupMenu(name(),this);
	CHECK_PTR( popup );
	popup->insertItem( SmallIcon("reload"), QString("Reload"), 
			   this, SLOT(reload(void)) );
	popup->insertSeparator();      
	popup->insertItem( SmallIcon("configure"), 
			   QString("Configure ").append(name()).append("..."), 
			   this, SLOT(preferences(void)) );

      }
      popup->popup(mapToGlobal(mev->pos()));
      return true;
    } else if ( mev->button() == QMouseEvent::LeftButton) {
      if (o == part->widget()) {
	if (browser_url == "")
	  return QWidget::eventFilter( o, e );
	KURL url(browser_url);
	if (url.isValid()) {
	  KProcess proc;
	  proc << "konqueror";
	  proc << browser_url;
	  proc.start();
	  proc.detach();
	}
      }else{
	candidate_url = selected_url;
	KURL url(selected_url);
	loadURL(url);
      }
      return true;
    }   
  }
  return QWidget::eventFilter( o, e );
}

void WebApplet::setCandidateURL(const QString& url)
{
  selected_url = url;
}

void WebApplet::setBrowserURL(const QString& url)
{
  browser_url = url;
}

void WebApplet::reload()
{
  QString urlstr = ksConfig->readEntry("URL","http://www.xspect.dk/kdetestapplet1.php");
  KURL url(urlstr);
  loadURL(url);
}

void WebApplet::loadURL(const KURL& url)
{
  
  if (part && url.isValid()) {
    KURL loadurl(url);
    QString q = url.query();
    q.append("&wa_width=").append(QString::number(width()));
    q.append("&wa_height=").append(QString::number(height()));
    QString pos;
    switch(position()) {
    case pTop:
      pos = "top";
      break;
    case pBottom:
      pos = "bottom";
      break;
    case pLeft:
      pos = "left";
      break;
    case pRight:
      pos = "right";
      break;
    default:
      pos = "bottom";
    }
    q.append("&wa_pos=").append(pos);
    loadurl.setQuery(q);
    part->openURL(loadurl);
  }
}

void WebApplet::about()
{
  KAboutData aboutData( "Web Applet", I18N_NOOP("Web Applet"), VERSION,
			I18N_NOOP("An applet for containing small web pages"),
			KAboutData::License_GPL_V2, "(c) 2002 Jonas Drewsen");

  aboutData.addAuthor("Jonas Drewsen", I18N_NOOP("Main Developer"), "kde@xspect.dk", "http://www.xspect.dk");

  KAboutApplication webappletabout(&aboutData);

  /*
  KIconLoader il("webapplet");
  QString path = il.iconPath("so_ok_lamp_14x14.png",KIcon::NoGroup);
  webappletabout.setImage("so_ok_lamp_14x14.png");
  */
  webappletabout.setCaption( i18n("About Web Applet") );
  webappletabout.exec();
}


void WebApplet::help()
{
  KMessageBox::information(0, i18n("Use this applet for viewing small webpages in the panel."));
}


void WebApplet::preferences()
{
  // Sync if another applet has changed the config file
  appletConfig->sync();

  conf = new configurationdialog(this, "Configure");
  
  QStringList sl = appletConfig->readListEntry("Servers");
  if (sl.empty()) {
    conf->ListBox1->insertItem("http://www.xspect.dk/kdewebapplet.php");
  }else{
    for(QStringList::iterator i = sl.begin() ; i != sl.end() ; ++i)
      conf->ListBox1->insertItem(*i);
  }
  
  conf->PushButton8->setEnabled(true);
  conf->ListBox1->sort();

  QBoxLayout * l = new QHBoxLayout( conf->Frame5 );
  l->setAutoAdd( TRUE );
  
  // Build html view
  tmppart =
    KParts::ComponentFactory::createPartInstanceFromQuery<KParts::ReadOnlyPart>( "text/html", QString::null, conf->Frame5, 0, conf->Frame5, 0 );
  if ( tmppart ) {
    KHTMLPart * _tmppart = static_cast<KHTMLPart*>(tmppart);
    connect(_tmppart,SIGNAL(onURL(const QString&)), 
    	    this, SLOT(setCandidateURL(const QString&)));
    _tmppart->begin();
    _tmppart->write("<html><body><h1 style='color:rgb(210,230,240)'>");
    _tmppart->write(i18n("Web applet") + "</h1><p>" + 
		    i18n("Please select a URL for the"
			 " left listbox to view the associated info. Select OK when "
			 "you have choosen the one you want in the kicker panel.") +
		    "</body></html>");
    _tmppart->end();

    dynamic_cast<QScrollView*>(tmppart->widget())->setVScrollBarMode(QScrollView::AlwaysOff);
    dynamic_cast<QScrollView*>(tmppart->widget())->setHScrollBarMode(QScrollView::AlwaysOff);
    tmppart->widget()->installEventFilter(this);
    tmppart->widget()->show();  
  }

  connect(conf->PushButton7, SIGNAL(clicked(void)),
	  this, SLOT(addServerDialog(void)));
  connect(conf->PushButton8, SIGNAL(clicked(void)),
	  this, SLOT(removeServerDialog(void)));
  connect(conf->ListBox1, SIGNAL(highlighted(const QString&)),
	  this, SLOT(serverSelected(const QString&)));

  // this line must be after the select signal has been connected
  conf->ListBox1->setSelected(0,true);

  QDialog::DialogCode res = (QDialog::DialogCode) conf->exec();
  
  // update config if necessary
  if (res == QDialog::Accepted) {
    if (candidate_url == "") {
      candidate_url = "http://www.xspect.dk/kdetestapplet1.php";
    }
    ksConfig->writeEntry("URL",candidate_url);
    ksConfig->sync();
    appletConfig->sync();
  }
  reload();
  delete conf;
}

void WebApplet::writeConfig()
{
  QStringList res;
  int count = conf->ListBox1->count();
  for (int i = 0; i < count ; ++i) {
    res.append(conf->ListBox1->item(i)->text());
  }
  appletConfig->writeEntry("Servers",res.join(","));
  appletConfig->sync();
}

void WebApplet::addServerDialog()
{
  addserverdialog * addconf = new addserverdialog(this, "Configure");
  addconf->LineEdit8->setText("http://");
  QDialog::DialogCode res = (QDialog::DialogCode) addconf->exec();

  // update config if necessary
  if (res == QDialog::Accepted) {
    QStringList sl = appletConfig->readListEntry("Servers");
    conf->ListBox1->insertItem(addconf->LineEdit8->text());
    conf->ListBox1->sort();
    writeConfig();
  }
}

void WebApplet::removeServerDialog()
{
  int res =  KMessageBox::warningYesNo(conf,i18n("Do you really want to remove the "
				       "Web applet URL from the list?"));
  if (res == KMessageBox::Yes) {
    int item = conf->ListBox1->currentItem();
    conf->ListBox1->removeItem(item);
    conf->ListBox1->sort();
    writeConfig();
    if (conf->ListBox1->count() == 0)
      conf->PushButton8->setEnabled(false);
  }
}

void WebApplet::serverSelected(const QString& /*server*/)
{
  conf->PushButton8->setEnabled(true);
  KURL url(conf->ListBox1->currentText());
  tmppart->openURL(url);
}

int WebApplet::widthForHeight(int height) const
{
  return height;
}

int WebApplet::heightForWidth(int width) const
{
  return width;
}

void WebApplet::resizeEvent(QResizeEvent */*e*/)
{
  //  part->widget()->setFixedSize(width(), height());
}

extern "C"
{
  KPanelApplet* init( QWidget *parent, const QString configFile)
  {
    KGlobal::locale()->insertCatalogue("WebApplet");
    return new WebApplet(configFile, KPanelApplet::Normal,
			 KPanelApplet::About | KPanelApplet::Help | 
			 KPanelApplet::Preferences,
			 parent, "WebApplet");
  }
}
